<?php

namespace App\Controller\Admin;

use EasyCorp\Bundle\EasyAdminBundle\Config\Dashboard;
use EasyCorp\Bundle\EasyAdminBundle\Config\MenuItem;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractDashboardController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

use Symfony\UX\Chartjs\Builder\ChartBuilderInterface;
use Symfony\UX\Chartjs\Model\Chart;
use EasyCorp\Bundle\EasyAdminBundle\Config\Locale;
use App\Entity\User;
class DashboardController extends AbstractDashboardController
{
    public function __construct(
        private ChartBuilderInterface $chartBuilder,
    ) {
    }

    // ... you'll also need to load some CSS/JavaScript assets to render
    // the charts; this is explained later in the chapter about Design

    #[Route('/admin', 'admin_dashboard')]
    public function index(): Response
    {
        $chart = $this->chartBuilder->createChart(Chart::TYPE_LINE);
        // ...set chart data and options somehow

        //return $this->render('admin/my-dashboard.html.twig', [
        return $this->render('@EasyAdmin/page/content.html.twig', [
            'chart' => $chart,
        ]);
    }

    public function configureDashboard() : Dashboard 
    {	
       return Dashboard::new()
          ->setTitle("LawyesScape")
    		->setLocales(['en', 'pl'])
            // to customize the labels of locales, pass a key => value array
            // (e.g. to display flags; although it's not a recommended practice,
            // because many languages/locales are not associated to a single country)
            ->setLocales([
                'en' => '🇬🇧 English',
                'pl' => '🇵🇱 Polski'
            ])
            // to further customize the locale option, pass an instance of
            // EasyCorp\Bundle\EasyAdminBundle\Config\Locale
            ->setLocales([
                'en', // locale without custom options
                Locale::new('pl', 'polski', 'far fa-language') // custom label and icon
            ]);
    }

    public function configureMenuItems() : iterable
    {
      // return MenuItem::new()->setMenuItem("eeee");
              // return [
    			//MenuItem::linkToLogout('Logout', 'fa fa-exit'),
               		//MenuItem::section("User Profile"),
	 yield MenuItem::linkToDashBoard("Dashboard","fa fa-home")->setPermission('ROLE_USER');
         yield MenuItem::linkToCrud('Seznam uživatelů', 'fas fa-list', User::class)->setPermission('ROLE_USER');
		//];    
}


}


