<?php

namespace App\Controller\Admin;

use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractCrudController;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextEditorField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use EasyCorp\Bundle\EasyAdminBundle\Field\ImageField;
//use Symfony\Component\Form\FileType;
use Symfony\Component\HttpFoundation\File\UploadedFile;
class UserCrudController extends AbstractCrudController
{
    public static function getEntityFqcn(): string
    {
        return User::class;
    }

    
    public function configureFields(string $pageName): iterable
    {
        return [
            //IdField::new('id'),
            TextField::new('email'),
            //TextEditorField::new('password'),
            TextField::new('password'),
        ImageField::new('pdf', 'Your PDF')
                    //->setFormType(UploadedFile::class)
                    ->setBasePath('documents/') //see documentation about ImageField to understand the difference beetwen setBasePath and setUploadDir
                    ->setUploadDir('public/documents/')
                    ->setColumns(6)
                    ->hideOnIndex()
                    ->setFormTypeOptions(['attr' => [
                            'accept' => 'application/pdf'
                        ]
                    ]),

        ];
    }
    /*public function configureFields(string $pageName): iterable
    {
        return [
            IdField::new('id'),
            TextField::new('title'),
            TextEditorField::new('description'),
        ];
    }*/


   public function configureActions(Actions $actions): Actions
   {
    return $actions
        // ...
        ->add(Crud::PAGE_INDEX, Action::DETAIL)
        ->add(Crud::PAGE_EDIT, Action::SAVE_AND_ADD_ANOTHER)
        //->remove(Crud::PAGE_INDEX, Action::NEW)
        ->remove(Crud::PAGE_DETAIL, Action::EDIT);
    }
}
