Upgrade between EasyAdmin 4.x versions
======================================

EasyAdmin 4.8.0
---------------

### Form Panels are now called Form Fieldsets

You can still use `FormField::addPanel()` but it's deprecated and it will be
removed in EasyAdmin 5.0.0. To fix the deprecation, "Find & Replace" in your IDE:

    // Before
    yield FormField::addPanel('...');

    // After
    yield FormField::addFieldset('...');

If your application uses custom advanced features, you might need to change some
other occurrences of "panel" such as CSS styles (`.form-panel` -> `.form-fieldset`)
and form attributes in `CrudFormType` (`$formFieldOptions['ea_form_panel']` ->
`$formFieldOptions['ea_form_fieldset'] = $currentFormFieldset`)

EasyAdmin 4.6.0
---------------

### New formatted value for Country field

This is a backward compatibility break that only affects you if you customize
the default `crud/field/country.html.twig` template or if you use a custom
template fo render `Country` fields.

Starting from this EasyAdmin version, `Country` fields allow to select more
than one value. That's why the type of the formatted value has changed from
`?string` to `?array`. E.g. if the value of your entity property is `ES`;
before, `field.formattedValue` stored the string `'Spain'` and now it stores
the array `['ES' => 'Spain']`.

The country code (used to display the country flag) is now the key of the new
array. Before, you had to use an internal propery called `flagCode` which has
been removed.

EasyAdmin 4.4.0
---------------

### Multilingual dashboards

EasyAdmin now supports multilingual dashboards. First, add the `_locale` parameter
in the URL of your dashboard (e.g. `/admin/{_locale}`) to enable the default
Symfony locale listener that handles the locale switching. If you can't do this,
you'll need to implement your own logic to handle the request locale in a way
compatible with Symfony.

After that, call the `setLocales()` method in the dashboard configuration class,
passing an array of locales that should be exposed in the interface.

EasyAdmin 4.2.0
---------------

### Signature changes

We've changed how translations are managed internally in EasyAdmin. Before we
passed translated contents to templates. Now we pass Symfony's "translatable"
objects to templates.

This means that many classes have been changed to allow using `TranslatableMessage` objects
in places where previously only `string`, `false` or `null` were allowed.
Return types were also loosened to allow returning `TranslatableMessage` where applicable.

In practice this should not affect to most applications because `TranslatableMessage`
objects gracefully transform to strings when needed. However, you might need to
update some checks where you only expected string scalar values and now you might
also get `TranslatableMessage` objects.

Full list of changes in final classes:

    Config\Action (new, setLabel); only docblocks and deprecation logic
    Config\Menu*MenuItem (constructors)
    Config\MenuItem (linkTo*, section, subMenu)
    Dto\ActionDto (getLabel, setLabel and private field)
    Dto\CrudDto (getEntityLabelInSingular, setEntityLabelInSingular,getEntityLabelInPlural, setEntityLabelInPlural, setCustomPageTitle, getHelpMessage, setHelpMessage)
    Dto\FieldDto (getLabel, setLabel, getHelp, setHelp)
    Dto\FilterDto (getLabel, setLabel); only docblocks
    Dto\MenuItemDto (getLabel, setLabel)
    Field*Field (new); only docblocks
    Field\FormField (addPanel, addTab)

List of signature changes in non-final classes and traits:

    Config\Crud (setHelp)
    Field\FieldTrait (setLabel, setHelp); setLabel only in docblock

### New setTranslatableChoices() method in `ChoiceField`

Use this method when defining choice labels with translatable objects. For example:

    yield ChoiceField::new('...')->setTranslatableChoices([
        'paid' => t('Paid Invoice'),
        'pending' => t('Invoice Sent but Unpaid'),
        'refunded' => 'Refunded Invoice', // You can mix strings with TranslatableMessage objects
    ]);

Upgrade between EasyAdmin 4.x versions
======================================

EasyAdmin 4.1.0
---------------

### Updated Country Field Flags

Flags that are optionally displayed in `CountryField` have been redesigned and
updated their format from `.png` to `.svg`. This doesn't require any change in
your application, but if you are using the flag images in your own custom designs,
update the path of the images:

```
# Before
<img alt="Flag of Panama" src="/bundles/easyadmin/images/flags/PA.png">

# After
<img alt="Flag of Panama" src="/bundles/easyadmin/images/flags/PA.svg">
```

### Removed URL signatures

Backend URLs no longer include signatures, because they don't provide any
additional security. The following classes and methods are deprecated:

  * `AdminUrlGenerator::addSignature()` method
  * `AdminUrlGenerator::getSignature()` method
  * `UrlSigner` class and service
  * `Dashboard::disableUrlSignatures()` method

The validity of URL signatures is no longer checked either. If you add signatures
manually, you'll need to check them too.
